-- judgment styles:
local JudgmentChoices = { "Normal", "sm-ssc", "Classic", "Groovy" }
local judgeState = {
	CurSelection = nil,		-- selection index
	CurStyle = nil,			-- style name (see JudgmentChoices above)
}
if ThemePrefs.Get("JudgeStyle") then
	judgeState.CurStyle = ThemePrefs.Get("JudgeStyle")
	for i=1,#JudgmentChoices do
		if JudgmentChoices[i] == judgeState.CurStyle then
			judgeState.CurSelection = i
		end
	end
end

return Def.ActorFrame{
	Def.Actor{
		Name="InputController";
		NewStateMessageCommand=function(self,p)
			local menuState = p.MenuState
			if menuState.CurState == "JudgmentStyle" then
				-- this should only happen if the preference wasn't read:
				if not judgeState.CurSelection then
					judgeState.CurSelection = 1
				end
				judgeState.CurStyle = JudgmentChoices[judgeState.CurSelection]
			end
		end;
		ThemeOptionsSubInputMessageCommand=function(self,p)
			local menuState = p.MenuState
			if menuState.CurState == "JudgmentStyle" then
				local curItem = judgeState.CurSelection
				local oldItem = curItem
				if p.Input == "Start" then
					-- save setting
					ThemePrefs.Set("JudgeStyle",JudgmentChoices[curItem])
					-- send input back to main
					menuState.CurState = nil
					menuState.JudgeStyle = curItem
					MESSAGEMAN:Broadcast("NewState", { MenuState = menuState })
				else
					if p.Input == "Up" then
						if curItem - 1 < 1 then
							curItem = #JudgmentChoices
						else
							curItem = curItem - 1
						end
						judgeState.CurSelection = curItem
						MESSAGEMAN:Broadcast("UpdateJudgmentPreview",{ NewPreview=curItem, OldPreview=oldItem })
					elseif p.Input == "Down" then
						if curItem + 1 > #JudgmentChoices then
							curItem = 1
						else
							curItem = curItem + 1
						end
						judgeState.CurSelection = curItem
						MESSAGEMAN:Broadcast("UpdateJudgmentPreview",{ NewPreview=curItem, OldPreview=oldItem })
					end
				end
			end
		end;
	};

	Def.ActorFrame{
		Name="JudgmentPreviews";
		InitCommand=cmd(x,SCREEN_CENTER_X+48;CenterY);
		BeginCommand=function(self)
			for i=1,#JudgmentChoices do
				if judgeState.CurStyle then
					if JudgmentChoices[i] == judgeState.CurStyle then
						self:GetChild("Judgment"..i):playcommand("GainFocus")
					else
						self:GetChild("Judgment"..i):playcommand("LoseFocus")
					end
				else
					local c = (i == 1) and "GainFocus" or "LoseFocus"
					self:GetChild("Judgment"..i):playcommand(c)
				end
			end
		end;
		UpdateJudgmentPreviewMessageCommand=function(self,param)
			local newJudge = param.NewPreview
			local oldJudge = param.OldPreview

			self:GetChild("Judgment"..oldJudge):playcommand("LoseFocus")
			self:GetChild("Judgment"..newJudge):playcommand("GainFocus")
		end;

		LoadActor(THEME:GetPathG("Judgment","Normal"))..{
			Name="Judgment1";
			InitCommand=cmd(SetAllStateDelays,2;y,-48;);
			GainFocusCommand=cmd(diffusealpha,1);
			LoseFocusCommand=cmd(diffusealpha,0.25);
		};
		LoadActor(THEME:GetPathG("Judgment","sm-ssc"))..{
			Name="Judgment2";
			InitCommand=cmd(SetAllStateDelays,2;y,-16;);
			GainFocusCommand=cmd(diffusealpha,1);
			LoseFocusCommand=cmd(diffusealpha,0.25);
		};
		LoadActor(THEME:GetPathG("Judgment","Classic"))..{
			Name="Judgment3";
			InitCommand=cmd(SetAllStateDelays,2;y,16;);
			GainFocusCommand=cmd(diffusealpha,1);
			LoseFocusCommand=cmd(diffusealpha,0.25);
		};
		LoadActor(THEME:GetPathG("Judgment","Groovy"))..{
			Name="Judgment4";
			InitCommand=cmd(SetAllStateDelays,2;y,48);
			GainFocusCommand=cmd(diffusealpha,1);
			LoseFocusCommand=cmd(diffusealpha,0.25);
		};
	};

	LoadFont("_francophilsans Bold 24px")..{
		InitCommand=cmd(xy,SCREEN_CENTER_X+48,SCREEN_CENTER_Y+82;zoom,16/24;shadowlength,1);
		BeginCommand=function(self)
			if judgeState.CurStyle then
				self:settext(judgeState.CurStyle)
			else
				self:settext( JudgmentChoices[1] )
			end
		end;
		UpdateJudgmentPreviewMessageCommand=function(self,param)
			local name = JudgmentChoices[param.NewPreview]
			self:settext(name)
		end;
	};
};